#!/bin/bash

# Reset PATH to system default
PATH=$(getconf PATH)

#Set your preferred Libero version if needed
Libero_ver=2025.1

echo "Using Libero version:" $Libero_ver

#===============================================================================
# Edit the following section with the location where the following tools are
# installed if they aren't in the default location:
#   - SoftConsole (SC_INSTALL_DIR)
#   - Libero (LIBERO_INSTALL_DIR)
#   - Licensing daemon for Libero (LICENSE_DAEMON_DIR)
#===============================================================================

export SC_INSTALL_DIR=/home/$USER/Microchip/SoftConsole-v2022.2-RISC-V-747
export LIBERO_INSTALL_DIR=/home/$USER/Microchip/Libero_SoC_$Libero_ver
export LICENSE_DAEMON_DIR=$LIBERO_INSTALL_DIR/LicenseDaemons
export LICENSE_FILE_DIR=/home/$USER/Microchip/license
export SMARTHLS_INSTALL_DIR=$LIBERO_INSTALL_DIR/SmartHLS/SmartHLS
export MSCC_IDE_VAULT_LOCATION=$LIBERO_INSTALL_DIR/MegaVault/Libero_SoC_v2025.1_MegaVault

export PATH=$PATH:$SC_INSTALL_DIR/riscv-unknown-elf-gcc/bin
export FPGENPROG=$LIBERO_INSTALL_DIR/Libero_SoC/Designer/bin64/fpgenprog


#
# Libero
#
export PATH=$PATH:$LIBERO_INSTALL_DIR/Libero_SoC/Designer/bin:$LIBERO_INSTALL_DIR/Libero_SoC/Designer/bin64
export PATH=$PATH:$LIBERO_INSTALL_DIR/Libero_SoC/Synplify_Pro/bin64:$LIBERO_INSTALL_DIR/Libero_SoC/Synplify_Pro/bin
export PATH=$PATH:$SMARTHLS_INSTALL_DIR/bin

#
# Libero License daemon
#
export LM_LICENSE_FILE=1702@localhost
export SNPSLMD_LICENSE_FILE=1702@localhost

$LICENSE_DAEMON_DIR/lmgrd -c $LICENSE_FILE_DIR/License.dat -l $LICENSE_FILE_DIR/license.log
